% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreastSubtypeR_methods.R
\name{BS_parker}
\alias{BS_parker}
\title{Original Parker Intrinsic Subtyping (BS_parker)}
\usage{
BS_parker(
  se_obj,
  calibration = "None",
  internal = NA,
  external = NA,
  medians = NA,
  Subtype = FALSE,
  hasClinical = FALSE
)
}
\arguments{
\item{se_obj}{A \code{SummarizedExperiment} object containing:
\itemize{
\item \strong{Assay data}: A log-transformed, normalized gene expression matrix with genes
(Gene Symbols) as rows and samples as columns.
\item \strong{Column metadata} (\code{colData}): Optional sample- or patient-level
information.
}}

\item{calibration}{Character. One of:
\itemize{
\item \code{"None"}: no centering/scaling.
\item \code{"Internal"}: center by a method derived from the current cohort (see \code{internal}).
\item \code{"External"}: center by medians from an external cohort (see \code{external}).
}}

\item{internal}{Internal calibration method used when \code{calibration = "Internal"}.
Accepts:
\itemize{
\item \code{NA} or \code{"medianCtr"} (identical): gene-wise median centering (as in Parker et al.).
\item \code{"meanCtr"}: gene-wise z-scoring (mean 0, sd 1; as implemented in \code{genefu.scale}).
\item \code{"qCtr"}: robust centering (quantile rescale with mq = 0.05; as in \code{genefu.robust}).
Defaults to \code{NA} (median centering).
}}

\item{external}{Character string specifying the external calibration source.
\itemize{
\item To use training cohort medians, provide the platform/column name.
\item To supply user-defined medians, set \code{external = "Given.mdns"} and pass
values via \code{medians}.
}}

\item{medians}{A matrix or data.frame of user-provided medians (required if
\code{external = "Given.mdns"}).
\itemize{
\item First column: 50 PAM50 genes.
\item Second column: Corresponding median expression values.
}}

\item{Subtype}{Logical. If \code{TRUE}, assigns only the four main intrinsic
subtypes (Luminal A, Luminal B, HER2-enriched, Basal-like),
excluding Normal-like.}

\item{hasClinical}{Logical. If \code{TRUE}, incorporates clinical variables from
\code{colData(se_obj)}. Required columns:
\itemize{
\item "TSIZE": Tumor size (0 = \eqn{\le 2}{<= 2} cm; 1 = \eqn{> 2}{> 2} cm).
\item "NODE": Lymph node status (0 = negative; \eqn{\ge 1}{>= 1} = positive). Must be numeric.
}}
}
\value{
A list containing PAM50 intrinsic subtype calls using the Parker
classifier and selected calibration strategy.
}
\description{
Implements the original PAM50 nearest-centroid classifier as described by
Parker et al. (2009), along with supported calibration strategies and
variations. This function assigns intrinsic breast cancer subtypes
(Luminal A, Luminal B, HER2-enriched, Basal-like, and optionally Normal-like).
}
\examples{
data("OSLO2EMIT0obj")
res <- BS_parker(
    se_obj = OSLO2EMIT0obj$data_input$se_NC,
    calibration = "Internal",
    internal = NA, # NA is equal to "medianCtr"
    Subtype = FALSE,
    hasClinical = FALSE
)

}
\references{
\itemize{
\item Parker JS, Mullins M, Cheung MCU, Leung S, Voduc D, et al.
\emph{Supervised risk predictor of breast cancer based on intrinsic subtypes}.
Journal of Clinical Oncology. 2009;27(8).
https://doi.org/10.1200/JCO.2008.18.1370
\item Gendoo DMA, Ratanasirigulchai N, Schröder MS, Paré L, Parker JS, Prat A, et al.
\emph{Genefu: An R/Bioconductor package for computation of gene expression-based signatures in breast cancer}.
Bioinformatics. 2016;32(7).
https://doi.org/10.1093/bioinformatics/btv693
}
}
