% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreastSubtypeR_methods.R
\name{BS_sspbc}
\alias{BS_sspbc}
\title{Intrinsic Subtyping using SSPBC (BS_sspbc)}
\usage{
BS_sspbc(se_obj, ssp.name = "ssp.pam50")
}
\arguments{
\item{se_obj}{A \code{SummarizedExperiment} object containing:
\itemize{
\item \strong{Assay data}: A gene expression matrix with genes (Entrez IDs) as rows
and samples as columns.
\itemize{
\item Expression values must be \strong{positive} (e.g., FPKM or log2(FPKM+1)).
\item Values should not be gene-centered or globally scaled.
}
}}

\item{ssp.name}{Character. Specifies the SSPBC model to use:
\itemize{
\item \code{"ssp.pam50"}: Predicts PAM50-based intrinsic subtypes.
\item \code{"ssp.subtype"}: Predicts Prosigna-like subtypes (four subtypes, excluding Normal-like).
}}
}
\value{
A \strong{list} with the following elements:
\itemize{
\item \code{cl}: Molecular class identified by the sspbc models for each sample
(one of \code{"Basal"}, \code{"Her2"}, \code{"LumA"}, \code{"LumB"}, with or without \code{"Normal"}).
\item \code{prob}: Numeric vector of posterior probabilities corresponding
to the assigned subtype in \code{cl} (one value per sample).
\item \code{all.probs}: Matrix of posterior probability values for all samples
and all subtypes (rows = samples, columns = subtypes).
\item \code{rules.matrix}: Binary (0/1) matrix of the pairwise gene-expression
rules (\emph{gene A < gene B}) used for assignment (rows = rules, columns = samples);
\code{1} indicates the rule evaluated to TRUE for that sample.
\item \code{data.used}: Expression values actually used to evaluate the simple rules.
\item \code{EntrezID.used}: Character vector of EntrezGene IDs used for rule evaluation.
}
}
\description{
Implements \strong{SSPBC (Single Sample Predictor for Breast Cancer)}, a
refinement of the original AIMS methodology trained on the large,
population-based SCAN-B RNA-seq cohort. SSPBC provides robust
single-sample predictions, independent of cohort composition, and supports
multiple model variants for different applications.
}
\examples{
## Example using SSPBC with the PAM50 model
data("OSLO2EMIT0obj")
res <- BS_sspbc(
    se_obj = OSLO2EMIT0obj$data_input$se_SSP,
    ssp.name = "ssp.pam50"
)

}
\references{
Staaf J, Häkkinen J, Hegardt C, Saal LH, Kimbung S, Hedenfalk I, et al.
\emph{RNA sequencing-based single sample predictors of molecular subtype and risk of recurrence for clinical assessment of early-stage breast cancer.}
NPJ Breast Cancer. 2022;8(1):27.
https://doi.org/10.1038/s41523-022-00465-3
}
