% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.R
\name{assignGeneID}
\alias{assignGeneID}
\alias{assignGeneID,GenomicRanges,GenomicRanges-method}
\alias{assignGeneID,RangedSummarizedExperiment,GenomicRanges-method}
\alias{assignGeneID,GenomicRanges,TxDb-method}
\alias{assignGeneID,RangedSummarizedExperiment,TxDb-method}
\title{Annotate ranges with gene ID.}
\usage{
assignGeneID(object, geneModels, ...)

\S4method{assignGeneID}{GenomicRanges,GenomicRanges}(
  object,
  geneModels,
  outputColumn = "geneID",
  swap = NULL,
  upstream = 1000,
  downstream = 100
)

\S4method{assignGeneID}{RangedSummarizedExperiment,GenomicRanges}(object, geneModels, ...)

\S4method{assignGeneID}{GenomicRanges,TxDb}(
  object,
  geneModels,
  outputColumn = "geneID",
  swap = NULL,
  upstream = 1000,
  downstream = 100
)

\S4method{assignGeneID}{RangedSummarizedExperiment,TxDb}(object, geneModels, ...)
}
\arguments{
\item{object}{GRanges or RangedSummarizedExperiment: Ranges to be annotated.}

\item{geneModels}{TxDb or GRanges: Gene models via a TxDb, or manually
specified as a GRangesList.}

\item{...}{additional arguments passed to methods.}

\item{outputColumn}{character: Name of column to hold geneID values.}

\item{swap}{character or NULL: If not NULL, use another set of ranges
contained in object to calculate overlaps, for example peaks in the thick
column.}

\item{upstream}{integer: Distance to extend annotated promoter upstream.}

\item{downstream}{integer: Distance to extend annotated promoter downstream.}
}
\value{
object with geneID added as a column in rowData (or mcols).
}
\description{
Annotate a set of ranges in a GRanges object with gene IDs (i.e. Entrez Gene
Identifiers) based on their genic context. Features overlapping multiple
genes are resolved by distance to the nearest TSS. Genes are obtained from a
TxDb object, or can manually supplied as a GRanges.
}
\examples{
data(exampleUnidirectional)

# Obtain gene models from a TxDb-object:
library(TxDb.Mmusculus.UCSC.mm9.knownGene)
txdb <- TxDb.Mmusculus.UCSC.mm9.knownGene

# Assign geneIDs
assignGeneID(exampleUnidirectional,
             geneModels=txdb,
             outputColumn='geneID')

# Assign geneIDs using only TC peaks:
assignGeneID(exampleUnidirectional,
             geneModels=txdb,
             outputColumn='geneID',
             swap='thick')
}
\seealso{
Other Annotation functions: 
\code{\link{assignMissingID}()},
\code{\link{assignTxID}()},
\code{\link{assignTxType}()}
}
\concept{Annotation functions}
