% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.R
\name{assignMissingID}
\alias{assignMissingID}
\alias{assignMissingID,character-method}
\alias{assignMissingID,GenomicRanges-method}
\alias{assignMissingID,RangedSummarizedExperiment-method}
\title{Annotate ranges with missing IDs.}
\usage{
assignMissingID(object, ...)

\S4method{assignMissingID}{character}(object, prefix = "Novel")

\S4method{assignMissingID}{GenomicRanges}(object, outputColumn = "geneID", prefix = "Novel")

\S4method{assignMissingID}{RangedSummarizedExperiment}(object, outputColumn = "geneID", prefix = "Novel")
}
\arguments{
\item{object}{character, GRanges or RangedSummarizedExperiment: IDs to have
NAs replaces with new IDs.}

\item{...}{additional arguments passed to methods.}

\item{prefix}{character: New name to assign to ranges with missing IDs, in
the style prefix1, prefix2, etc.}

\item{outputColumn}{character: Name of column to hold txID values.}
}
\value{
object with NAs replaced in outputColumn
}
\description{
This function can relabel ranges with missing IDs (i.e. returned by
assignTxID and assignGeneID), in case they need to be retained for further
analysis.
}
\examples{
data(exampleUnidirectional)

# Obtain gene models from a TxDb-object:
library(TxDb.Mmusculus.UCSC.mm9.knownGene)
txdb <- TxDb.Mmusculus.UCSC.mm9.knownGene

# Assign geneIDs using only TC peaks:
exampleUnidirectional <- assignGeneID(exampleUnidirectional,
                                      geneModels=txdb,
                                      outputColumn='geneID',
                                      swap='thick')

# Replace NAs with 'Novel'
assignMissingID(exampleUnidirectional)

# Replace NAs with 'NovelTSS'
assignMissingID(exampleUnidirectional, prefix = 'NovelTSS')
}
\seealso{
Other Annotation functions: 
\code{\link{assignGeneID}()},
\code{\link{assignTxID}()},
\code{\link{assignTxType}()}
}
\concept{Annotation functions}
