% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhancers.R
\name{calcBidirectionality}
\alias{calcBidirectionality}
\alias{calcBidirectionality,GRanges-method}
\alias{calcBidirectionality,GPos-method}
\alias{calcBidirectionality,RangedSummarizedExperiment-method}
\title{Calculate sample-wise bidirectionally of clusters.}
\usage{
calcBidirectionality(object, ...)

\S4method{calcBidirectionality}{GRanges}(
  object,
  samples,
  inputAssay = "counts",
  outputColumn = "bidirectionality"
)

\S4method{calcBidirectionality}{GPos}(object, ...)

\S4method{calcBidirectionality}{RangedSummarizedExperiment}(object, ...)
}
\arguments{
\item{object}{GenomicRanges or RangedSummarizedExperiment: Unstranded
clusters with midpoints stored in the 'thick' column.}

\item{...}{additional arguments passed to methods.}

\item{samples}{RangedSummarizedExperiment: Sample-wise CTSSs stored as an
assay.}

\item{inputAssay}{character: Name of assay in samples holding input CTSS
values.}

\item{outputColumn}{character: Name of column in object to hold
bidirectionality values.}
}
\value{
object returned with bidirectionality scores added in rowData (or
  mcols).
}
\description{
For each cluster, calculate how many individual samples shows transcription
in both directions. This is refered to as the 'bidirectionality'. Clusters
must be unstranded (*) and have a midpoint stored in the thick column
}
\examples{
data(exampleCTSSs)
data(exampleBidirectional)

calcBidirectionality(exampleBidirectional, samples=exampleCTSSs)
}
\seealso{
Other Calculation functions: 
\code{\link{calcComposition}()},
\code{\link{calcPooled}()},
\code{\link{calcShape}()},
\code{\link{calcSupport}()},
\code{\link{calcTPM}()},
\code{\link{calcTotalTags}()},
\code{\link{subsetByBidirectionality}()},
\code{\link{subsetByComposition}()},
\code{\link{subsetBySupport}()}
}
\concept{Calculation functions}
