% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{calcComposition}
\alias{calcComposition}
\title{Calculate composition of CAGE data.}
\usage{
calcComposition(
  object,
  inputAssay = "counts",
  outputColumn = "composition",
  unexpressed = 0.1,
  genes = "geneID"
)
}
\arguments{
\item{object}{RangedSummarizedExperiment: CAGE data quantified at CTSS,
cluster or gene-level.}

\item{inputAssay}{character: Name of assay holding input expression values.}

\item{outputColumn}{character: Name of column in rowRanges to hold
composition values.}

\item{unexpressed}{numeric: Composition will be calculated based on features
larger than this cutoff.}

\item{genes}{character: Name of column in rowData holding genes (NAs are not
currently allowed.)}
}
\value{
object with composition added as a column in rowData.
}
\description{
For every feature, count in how many samples it is expressed above a certain
fraction (e.g. 10 percent) within a grouping, usually genes. This count is
refered to as the 'composition' value.
}
\examples{
data(exampleUnidirectional)

# Annotate clusters with geneIDs:
library(TxDb.Mmusculus.UCSC.mm9.knownGene)
txdb <- TxDb.Mmusculus.UCSC.mm9.knownGene
exampleUnidirectional <- assignGeneID(exampleUnidirectional,
                                      geneModels=txdb,
                                      outputColumn='geneID',
                                      swap='thick')

# Calculate composition values:
exampleUnidirectional <- subset(exampleUnidirectional, !is.na(geneID))
calcComposition(exampleUnidirectional)

# Use a lower threshold
calcComposition(exampleUnidirectional,
                unexpressed=0.05,
                outputColumn='lenientComposition')
}
\seealso{
Other Calculation functions: 
\code{\link{calcBidirectionality}()},
\code{\link{calcPooled}()},
\code{\link{calcShape}()},
\code{\link{calcSupport}()},
\code{\link{calcTPM}()},
\code{\link{calcTotalTags}()},
\code{\link{subsetByBidirectionality}()},
\code{\link{subsetByComposition}()},
\code{\link{subsetBySupport}()}
}
\concept{Calculation functions}
