% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{calcTPM}
\alias{calcTPM}
\title{Calculate CAGE Tags-Per-Million (TPM)}
\usage{
calcTPM(
  object,
  inputAssay = "counts",
  outputAssay = "TPM",
  totalTags = NULL,
  outputColumn = "totalTags"
)
}
\arguments{
\item{object}{RangedSummarizedExperiment: CAGE data quantified at CTSS,
cluster or gene-level.}

\item{inputAssay}{character: Name of assay holding input expression values.}

\item{outputAssay}{character: Name of assay to hold TPM values.}

\item{totalTags}{character or NULL: Column in colData holding the total
number of tags for each samples. If NULL, this will be calculated using
calcTotalTags.}

\item{outputColumn}{character: Name of column in colData to hold number of
total tags, only used if totalTags is NULL.}
}
\value{
object with TPM-values added as a new assay. If totalTags is NULL,
  total tags added as a column in colData.
}
\description{
Normalize CAGE-tag counts into TPM values.
}
\examples{
data(exampleUnidirectional)

# Calculate TPM:
calcTPM(exampleUnidirectional)

# Use pre-calculated total number of tags:
calcTPM(exampleUnidirectional,
        outputAssay='TPMsupplied',
        totalTags='totalTags')
}
\seealso{
Other Calculation functions: 
\code{\link{calcBidirectionality}()},
\code{\link{calcComposition}()},
\code{\link{calcPooled}()},
\code{\link{calcShape}()},
\code{\link{calcSupport}()},
\code{\link{calcTotalTags}()},
\code{\link{subsetByBidirectionality}()},
\code{\link{subsetByComposition}()},
\code{\link{subsetBySupport}()}
}
\concept{Calculation functions}
