% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bam.R
\name{convertBAM2BigWig}
\alias{convertBAM2BigWig}
\title{Extract CTSSs from BAM-files (EXPERIMENTAL)}
\usage{
convertBAM2BigWig(input, outputPlus, outputMinus, minLength = 1L, ...)
}
\arguments{
\item{input}{character: Path to input BAM-file}

\item{outputPlus}{character: Path to output BigWig-file holding CTSSs on the
plus strand.}

\item{outputMinus}{character: Path to output BigWig-file holding CTSSs on the
minus strand.}

\item{minLength}{integer: Minimum length of mapped reads.}

\item{...}{Additional arguments passed to rtracklayer::import. This will
often include a ScanBamParam}
}
\value{
Number of CTSSs/Tags returned invisibly.
}
\description{
Function for converting mapped reads in BAM-files to CAGE Transcription Start
Sites (CTSSs) in BigWig-files. Currently, this function will simply load a
(single-end) BAM-file (respecting a supplied ScanBamParam), optionally remove
short tags, and count the number of 5'-ends at each bp. Note, the BAM-file is
loaded as a single object, so you must be able to keep at least one complete
BAM-file in RAM.
}
\note{
WARNING: This function is experimental, has not been thoroughly tested,
  and will most likely significantly change in upcoming CAGEfightR version.
  For comments/question please go to  the CAGEfightR github page.
}
\examples{
# TBA
}
