% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convertBED2BigWig}
\alias{convertBED2BigWig}
\alias{convertBED2BedGraph}
\alias{convertBedGraph2BigWig}
\alias{convertBigWig2BedGraph}
\alias{convertBigWig2BED}
\alias{convertBedGraph2BED}
\title{Convert CTSSs stored in different file formats.}
\usage{
convertBED2BigWig(input, outputPlus, outputMinus, genome)

convertBED2BedGraph(input, outputPlus, outputMinus)

convertBedGraph2BigWig(input, output, genome)

convertBigWig2BedGraph(input, output)

convertBigWig2BED(inputPlus, inputMinus, output)

convertBedGraph2BED(inputPlus, inputMinus, output)
}
\arguments{
\item{input}{charater: Path to input files holding CTSSs on both strands.}

\item{outputPlus}{character: Path to output files holding CTSSs on plus strand.}

\item{outputMinus}{character: Path to output files holding CTSSs on minus strand.}

\item{genome}{Seqinfo or character: Genome info passed to rtracklayer::import  (see note).}

\item{output}{charater: Path to output files holding CTSSs on both strands.}

\item{inputPlus}{character: Path to input files holding CTSSs on plus strand.}

\item{inputMinus}{character: Path to input files holding CTSSs on minus strand.}
}
\value{
TRUE returned invisibly if conversion(s) was succesful, otherwise an error is raised.
}
\description{
Collection of functions for converting CTSSs/CTSSs-like data stored in
BigWig, bedGraph or BED file formats. BigWig and bedGraph files use a file
for each strand, while BED-files stores both strands in a single file. As
BigWig files stores info about the chromosome lenghts, conversion from
bedGraph/BED to BigWig requires a genome. Note that CAGEfightR will only
import BigWig or bedGraph files!
}
\note{
These functions will warn if input files do not have the correct
  extensions (.bw, .bedGraph, .bed), but otherwise simply pass input to
  rtracklayer::import. This makes them able to handle compressed files (like
  .gz). The same applies to the genome argument, which can also be the name
  of a UCSC genome.
}
\examples{
\dontrun{
# Find paths to BigWig files
data('exampleDesign')
bw_plus <- system.file('extdata', exampleDesign$BigWigPlus,
                       package = 'CAGEfightR')
bw_minus <- system.file('extdata', exampleDesign$BigWigMinus,
                        package = 'CAGEfightR')

# Designate paths to new files
n_samples <- length(bw_plus)
beds <- replicate(n=n_samples, tempfile(fileext=".bed"))
bg_plus <- replicate(n=n_samples, tempfile(fileext="_plus.bedGraph"))
bg_minus <- replicate(n=n_samples, tempfile(fileext="_minus.bedGraph"))
conv_plus <- replicate(n=n_samples, tempfile(fileext="_plus.bw"))
conv_minus <- replicate(n=n_samples, tempfile(fileext="_minus.bw"))

# Convert BigWig to BED
convertBigWig2BED(inputPlus=bw_plus,
                  inputMinus=bw_minus,
                  output=beds)

# Convert BED to bedGraph
convertBED2BedGraph(input=beds,
                    outputPlus=bg_plus,
                    outputMinus=bg_minus)

# Convert BED to bedGraph
mm9 <- SeqinfoForUCSCGenome("mm9")
convertBED2BigWig(input=beds,
                  outputPlus=conv_plus,
                  outputMinus=conv_minus,
                  genome=mm9)

# Check it's still the same data
x <- import(bw_plus[1])
y <- import(bg_plus[1])
z <- import(conv_plus[1])
all(x == y)
all(x == z)
sum(score(x)) ==  sum(score(y))
sum(score(x)) ==  sum(score(z))
}
}
