% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{utilsScoreOverlaps}
\alias{utilsScoreOverlaps}
\title{Utility: Counting overlaps taking into account scores}
\usage{
utilsScoreOverlaps(query, subject, ...)
}
\arguments{
\item{query}{same as findOverlaps/countOverlaps}

\item{subject}{same as findOverlaps/countOverlaps}

\item{...}{additional arguments passed to findOverlaps}
}
\value{
vector of number of overlaps weigthed by score column.
}
\description{
Similar to countOverlaps, but takes the score column into account.
}
\examples{
gr1 <- GRanges(seqnames="chr1",
               ranges=IRanges(start = c(4, 9, 10, 30),
                              end = c(4, 15, 20, 31)),
               strand="+")
gr2 <- GRanges(seqnames="chr1",
               ranges=IRanges(start = c(1, 4, 15, 25),
                              end = c(2, 4, 20, 26)),
               strand=c("+"),
               score=c(10, 20, 15, 5))
countOverlaps(gr1, gr2)
utilsScoreOverlaps(gr1, gr2)
}
\seealso{
\url{https://support.bioconductor.org/p/87736/#87758}

Other Utility functions: 
\code{\link{utilsAggregateRows}()},
\code{\link{utilsDeStrand}()},
\code{\link{utilsSimplifyTxDb}()}
}
\concept{Utility functions}
