% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R
\name{consensusClustersGR}
\alias{consensusClustersGR}
\alias{consensusClustersGR,CAGEexp-method}
\alias{consensusClustersSE}
\alias{consensusClustersSE,CAGEexp-method}
\title{Get consensus clusters from CAGEr objects}
\usage{
consensusClustersGR(object, sample = NULL, qLow = NULL, qUp = NULL)

\S4method{consensusClustersGR}{CAGEexp}(object, sample = NULL, qLow = NULL, qUp = NULL)

consensusClustersSE(object)

\S4method{consensusClustersSE}{CAGEexp}(object)
}
\arguments{
\item{object}{A \code{\link{CAGEr}} object.}

\item{sample}{Optional. Label of the CAGE dataset (experiment, sample) for
which to extract sample-specific information on consensus clusters.}

\item{qLow, qUp}{Lower and upper quantiles to compute interquantile width.}
}
\value{
\code{consensusClustersGR} returns a \code{\link{ConsensusClusters}} object, which
wraps the \code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}} class.  The \code{score} columns indicates the
normalised expression value of each cluster, either across all samples
(\code{sample = NULL}), or for the selected sample.  The legacy \code{tpm} column may
be removed in the future.  When \code{sample} argument is
NOT specified, total CAGE signal across all CAGE datasets (samples) is
returned in the \code{tpm} column.  When \code{sample} argument is specified, the \code{tpm}
column contains CAGE signal of consensus clusters in that specific sample.
In addition, sample-specific information  is returned, including position of
the dominant TSS, and (if applicable) interquantile width of the consensus
clusters in the specified sample or otherwise, sample-agnostic information is
returned.

\code{consensusClustersSE} returns the \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment}} stored
in the \code{consensusClusters} experiment slot of the CAGEexp object.
}
\description{
Extracts the information on consensus clusters from a \code{\link{CAGEr}}
object.
}
\examples{
consensusClustersGR( exampleCAGEexp, sample = 2
                   , qLow = 0.1, qUp = 0.9)

}
\seealso{
\code{\link[=consensusClusters<-]{consensusClusters<-()}}

Other CAGEr accessor methods: 
\code{\link{CTSScoordinatesGR}()},
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CTSSnormalizedTpmDF}()},
\code{\link{CTSStagCountDF}()},
\code{\link{GeneExpDESeq2}()},
\code{\link{GeneExpSE}()},
\code{\link{expressionClasses}()},
\code{\link{filteredCTSSidx}()},
\code{\link{genomeName}()},
\code{\link{inputFiles}()},
\code{\link{inputFilesType}()},
\code{\link{librarySizes}()},
\code{\link{sampleLabels}()},
\code{\link{seqNameTotalsSE}()},
\code{\link{tagClustersGR}()}

Other CAGEr clusters functions: 
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{consensusClustersDESeq2}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{paraclu}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{quantilePositions}()},
\code{\link{tagClustersGR}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr accessor methods}
\concept{CAGEr clusters functions}
