% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{CARD_visualize_gene}
\alias{CARD_visualize_gene}
\title{Visualize the spatial distribution of cell type proportion}
\usage{
CARD_visualize_gene(
  spatial_expression,
  spatial_location,
  gene_visualize,
  colors = colors,
  NumCols
)
}
\arguments{
\item{spatial_expression}{Data frame, spatial gene expression in either
original resolution or enhanced resolution.}

\item{spatial_location}{Data frame, spatial location information.}

\item{gene_visualize}{Vector of selected gene names that are interested to
visualize}

\item{colors}{Vector of color names that you want to use, if NULL, we will
use the default color scale in virdis palette}

\item{NumCols}{Numeric, number of columns in the figure panel, it depends on
the number of cell types you want to visualize.}
}
\value{
Returns a ggplot2 figure.
}
\description{
Visualize the spatial distribution of cell type proportion
}
\examples{
library(ggplot2)
library(SummarizedExperiment)
library(SpatialExperiment)
data(spatial_count)
data(spatial_location)
data(sc_count)
data(sc_meta)
CARD_obj <- CARD_deconvolution(
    sc_count = sc_count,
    sc_meta = sc_meta,
    spatial_count = spatial_count,
    spatial_location = spatial_location,
    ct_varname = "cellType",
    ct_select = unique(sc_meta$cellType),
    sample_varname = "sampleInfo",
    mincountgene = 100,
    mincountspot = 5
)
CARD_visualize_gene(
    spatial_expression = assays(CARD_obj)$spatial_countMat,
    spatial_location = spatialCoords(CARD_obj),
    gene_visualize = c("A4GNT", "AAMDC", "CD248"),
    colors = NULL,
    NumCols = 3
)

}
