% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{CARD_visualize_prop}
\alias{CARD_visualize_prop}
\title{Visualize the spatial distribution of cell type proportion}
\usage{
CARD_visualize_prop(
  proportion,
  spatial_location,
  ct_visualize = ct_visualize,
  colors = c("lightblue", "lightyellow", "red"),
  NumCols,
  pointSize = 3
)
}
\arguments{
\item{proportion}{Data frame, cell type proportion estimated by CARD in
either original resolution or enhanced resolution.}

\item{spatial_location}{Data frame, spatial location information.}

\item{ct_visualize}{Vector of selected cell type names that are
interested to visualize}

\item{colors}{Vector of color names that you want to use, if NULL, we will
use the default color scale c("lightblue","lightyellow","red")}

\item{NumCols}{Numeric, number of columns in the figure panel, it depends on
the number of cell types you want to visualize.}

\item{pointSize}{Size of each point used for plotting}
}
\value{
Returns a ggplot2 figure.
}
\description{
Visualize the spatial distribution of cell type proportion
}
\examples{
library(ggplot2)
library(SpatialExperiment)
data(spatial_count)
data(spatial_location)
data(sc_count)
data(sc_meta)
CARD_obj <- CARD_deconvolution(
    sc_count = sc_count,
    sc_meta = sc_meta,
    spatial_count = spatial_count,
    spatial_location = spatial_location,
    ct_varname = "cellType",
    ct_select = unique(sc_meta$cellType),
    sample_varname = "sampleInfo",
    mincountgene = 100,
    mincountspot = 5
)
ct_visualize <- c(
    "Acinar_cells", "Cancer_clone_A", "Cancer_clone_B",
    "Ductal_terminal_ductal_like", "Ductal_CRISP3_high-centroacinar_like",
    "Ductal_MHC_Class_II", "Ductal_APOL1_high-hypoxic", "Fibroblasts"
)
CARD_visualize_prop(
    proportion = CARD_obj$Proportion_CARD,
    spatial_location = spatialCoords(CARD_obj),
    ct_visualize = ct_visualize,
    colors = c("lightblue", "lightyellow", "red"),
    NumCols = 4,
    pointSize = 3.0
)

}
