% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_run_carnival.R
\name{isInputValidCarnival}
\alias{isInputValidCarnival}
\title{Checks validity of all inputs of CARNIVAL}
\usage{
isInputValidCarnival(
  perturbations = NULL,
  measurements,
  priorKnowledgeNetwork,
  weights = NULL,
  carnivalOptions = defaultLpSolveCarnivalOptions()
)
}
\arguments{
\item{perturbations}{(optional, if inverse CARNIVAL flavour is used further) vector of targets of perturbations.}

\item{measurements}{vector of the measurements (i.e. DoRothEA/VIPER normalised
enrichment scores)}

\item{priorKnowledgeNetwork}{data frame of the prior knowledge network}

\item{weights}{(optional) vector of the additional weights: e.g. PROGENy pathway
scores or measured protein activities.}

\item{carnivalOptions}{the list of options for the run. See defaultLpSolveCarnivalOptions(),
defaultCplexCarnivalOptions, defaultCbcCarnivalOptions.}
}
\value{
TRUE if everything passed the checks.
}
\description{
Checks validity of all inputs of CARNIVAL
}
\examples{
load(file = system.file("toy_perturbations_ex1.RData",
                        package="CARNIVAL"))
load(file = system.file("toy_measurements_ex1.RData",
                        package="CARNIVAL"))
load(file = system.file("toy_network_ex1.RData",
                        package="CARNIVAL"))

## lpSolve
#isInputValidCarnival(perturbations = toy_perturbations_ex1,
#                    measurements = toy_measurements_ex1,
#                    priorKnowledgeNetwork = toy_network_ex1,
#                    carnivalOptions = defaultLpSolveCarnivalOptions())
}
