% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_run_carnival.R
\name{runVanillaCarnival}
\alias{runVanillaCarnival}
\title{\code{runVanillaCarnival}}
\usage{
runVanillaCarnival(
  perturbations,
  measurements,
  priorKnowledgeNetwork,
  weights = NULL,
  carnivalOptions = defaultLpSolveCarnivalOptions()
)
}
\arguments{
\item{perturbations}{vector of targets of perturbations.}

\item{measurements}{vector of the measurements (i.e. DoRothEA/VIPER normalised
enrichment scores)}

\item{priorKnowledgeNetwork}{data frame of the prior knowledge network}

\item{weights}{(optional) vector of the additional weights: e.g. PROGENy pathway
score or measured protein activities.}

\item{carnivalOptions}{the list of options for the run. See defaultLpSolveCarnivalOptions(),
defaultLpSolveCarnivalOptions, defaultCbcCarnivalOptions.}
}
\value{
The function will return a list of results containing:
1. weightedSIF: A table with 4 columns containing the combined network
solutions from CARNIVAL. It contains the Source of the interaction (Node1),
Sign of the interaction (Sign), the Target of the interaction (Node2) and the
weight of the interaction (Weight) which shows how often an interaction
appears across all solutions.

2. nodesAttributes: A table with 6 columns containing information about
infered protein activity states and attributes. It contains the Protein IDs
(Node); how often this node has taken an activity of 0, 1 and -1 across the
solutions (ZeroAct, UpAct, DownAct); the average activities across solutions
(AvgAct); and the node attribute (measured, target, inferred).

3. sifAll: A list of separate network solutions.

4. attributesAll: A list of separate inferred node activities in each
solution.

5. diagnostics: reports the convergence of optimization and reason of
the termination. Only for CPLEX solver.
}
\description{
\code{runVanillaCarnival}
}
\details{
Runs full CARNIVAL pipeline, vanilla(classic) flavour.
}
\examples{
load(file = system.file("toy_perturbations_ex1.RData",
                       package="CARNIVAL"))
load(file = system.file("toy_measurements_ex1.RData",
                       package="CARNIVAL"))
load(file = system.file("toy_network_ex1.RData",
                       package="CARNIVAL"))

## lpSolve
#res1 = runVanillaCarnival(perturbations = toy_perturbations_ex1,
#                          measurements = toy_measurements_ex1,
#                          priorKnowledgeNetwork = toy_network_ex1,
#                          carnivalOptions = defaultLpSolveCarnivalOptions())

#res1$weightedSIF ##see @return
#res1$nodesAttributes ## see @return
#res1$sifAll ## see @return
#res1$attributesAll ## see @return

## Examples for cbc and cplex are commented out because these solvers are not part of R environment
## and need to be installed separately
##
## cbc
## res2 = runVanillaCarnival(perturbations = toy_perturbations_ex1,
##                               measurements = toy_measurements_ex1,
##                               priorKnowledgeNetwork = toy_network_ex1,
##                               carnivalOptions = defaultCbcCarnivalOptions())
##
## res2$weightedSIF ##see @return
## res2$nodesAttributes ## see @return
## res2$sifAll ## see @return
## res2$attributesAll ## see @return
##
## cplex
## res3 = runVanillaCarnival(perturbations = toy_perturbations_ex1,
##                              measurements = toy_measurements_ex1,
##                              priorKnowledgeNetwork = toy_network_ex1,
##                              carnivalOptions = defaultCplexCarnivalOptions())
##
## res3$weightedSIF ##see @return
## res3$nodesAttributes ## see @return
## res3$sifAll ## see @return
## res3$attributesAll ## see @return

}
\author{
Enio Gjerga, Olga Ivanova 2020-2021 \email{carnival.developers@gmail.com}
}
