% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clrDR.R
\name{clrDR}
\alias{clrDR}
\title{DR plot on CLR of proportions}
\usage{
clrDR(
  x,
  dr = c("PCA", "MDS", "UMAP", "TSNE", "DiffusionMap"),
  by = c("sample_id", "cluster_id"),
  k = "meta20",
  dims = c(1, 2),
  base = 2,
  arrows = TRUE,
  point_col = switch(by, sample_id = "condition", "cluster_id"),
  arrow_col = switch(by, sample_id = "cluster_id", "condition"),
  arrow_len = 0.5,
  arrow_opa = 0.5,
  label_by = NULL,
  size_by = TRUE,
  point_pal = NULL,
  arrow_pal = NULL
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{dr}{character string specifying which dimension reduction to use.}

\item{by}{character string specifying across which IDs to compute CLRs
\itemize{
\item{\code{by = "sample_id"} compute CLRs across
  relative abundances of samples across clusters;
  each point in the embedded space represents a sample.}
\item{\code{by = "cluster_id"} compute CLRs across
  relative abundances of clusters across samples;
  each point in the embedded space represents a cluster.}
}}

\item{k}{character string specifying which clustering to use;
valid values are \code{names(cluster_codes(x))}.}

\item{dims}{two numeric scalars indicating which dimensions to plot.}

\item{base}{integer scalar specifying the logarithm base to use.}

\item{arrows}{logical specifying whether to include arrows for PC loadings.}

\item{point_col, arrow_col}{character string specifying a non-numeric
cell metadata column to color points and PC loading arrows by;
valid values are \code{names(colData(x))}.}

\item{arrow_len}{non-zero single numeric specifying the length of loading
vectors relative to the largest xy-coordinate in the embedded space;
NULL for no re-sizing (see details).}

\item{arrow_opa}{single numeric in [0,1] specifying the opacity (alpha)
of PC loading arrows when they are grouped; 0 will hide individual arrows.}

\item{label_by}{character string specifying a non-numeric sample metadata
variable to label points by; valid values are \code{names(colData(x))}.}

\item{size_by}{logical specifying whether to scale point sizes by the number
of cells in a given sample/cluster (for \code{by = "sample/cluster_id"}).}

\item{point_pal, arrow_pal}{character string of colors to use
for points and PC loading arrows. Arguments default to
\code{.cluster_cols} for clusters (defined internally),
and \code{brewer.pal}'s \code{"Set3"} for samples.}
}
\value{
a \code{ggplot} object.
}
\description{
Computes centered log-ratios (CLR) on cluster/sample proportions across
samples/clusters, and visualizes them in a lower-dimensional space,
highlighting differences in composition between samples/clusters.
}
\details{
\describe{
\item{The centered log-ratio (CLR)}{
Let \code{k} be one of \eqn{S} samples, \code{k} one of \eqn{K} clusters,
and \code{p(s,k)} be the proportion of cells from \code{s} in \eqn{k}.
The centered log-ratio (CLR) is defined as
\deqn{clr(sk) = log p(s,k) - \sum p(s,k) / K}
and analogous for clusters replacing \code{s} by \code{k} and \code{K} by
\code{S}. Thus, each sample/cluster gives a vector with length \code{K/S}
and mean 0, and the CLRs computed across all instances can be represented
as a matrix with dimensions \code{S} x \code{K} (or \code{K} x \code{S}
for clusters) that we embed into a lower dimensional space.}

\item{Dimensionality reduction}{
In principle, \code{clrDR} allows any dimension reduction to be applied on
the CLRs. The default method (\code{dr = "PCA"}) will include the percentage
of variance explained by each principal component (PC) in the axis labels.

Noteworthily, distances between points in the lower-dimensional space are
meaningful only for linear DR methods (PCA and MDS), and results obtained
from other methods should be interpreted with caution. Thus, the output
plot's aspect ratio should be kept as is for PCA and MDS; non-linear
DR methods can use \code{aspect.ratio = 1}, rendering a square plot.}

\item{Interpreting PC loadings}{
For \code{dr = "PCA"}, PC loadings will be represented as arrows that may be
interpreted as follows: 0° (180°) between vectors indicates a strong positive
(negative) relation between them, while vectors that are orthogonal to each
another (90°) are roughly independent.

When a vector points towards a given quadrant, the variability in proportions
for the points within this quadrant are largely driven by the corresponding
variable. Here, only the relative orientation of vectors to one another and
to the PC axes is meaningful; however, the sign of loadings (i.e., whether
an arrow points left or right) can be flipped when re-computing PCs.

When \code{arrow_len} is specified, PC loading vectors will be re-scaled to
improve their visibility. Here, a value of 1 will stretch vectors such that
the largest loading will touch on the outer most point. Importantly, while
absolute arrow lengths are not interpretable, their relative length is.}}
}
\examples{
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)
sce <- cluster(sce)

# CLR on sample proportions across clusters
# (1st vs. 3rd PCA; include sample labels)
clrDR(sce, by = "sample_id", k = "meta12",
  dims = c(1, 3), label_by = "sample_id")

# CLR on cluster proportions across samples
# (use custom colors for both points & loadings)
clrDR(sce, by = "cluster_id",
  point_pal = hcl.colors(10, "Spectral"),
  arrow_pal = c("royalblue", "orange"))

}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
