% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNRS.R
\name{plotNRS}
\alias{plotNRS}
\title{Plot non-redundancy scores}
\usage{
plotNRS(x, features = NULL, color_by = "condition", assay = "exprs")
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{features}{a character vector specifying 
which antigens to use for clustering; valid values are
\code{"type"/"state"} for \code{type/state_markers(x)} 
if \code{rowData(x)$marker_class} have been specified; 
a subset of \code{rownames(x)}; NULL to use all features.}

\item{color_by}{character string specifying the color coding;
valid values are \code{namescolData(x))}.}

\item{assay}{character string specifying which assay data 
to use; valid values are \code{assayNames(x)}.}
}
\value{
a \code{ggplot} object.
}
\description{
Plots non-redundancy scores (NRS) by feature 
in decreasing order of average NRS across samples.
}
\examples{
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)

plotNRS(sce, features = NULL)   # default: all markers
plotNRS(sce, features = "type") # type-markers only

}
\references{
Nowicka M, Krieg C, Crowell HL, Weber LM et al. 
CyTOF workflow: Differential discovery in 
high-throughput high-dimensional cytometry datasets.
\emph{F1000Research} 2017, 6:748 (doi: 10.12688/f1000research.11622.1)
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
