% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bngeneplot.R
\name{bngeneplot}
\alias{bngeneplot}
\title{bngeneplot}
\usage{
bngeneplot(
  results,
  exp,
  expSample = NULL,
  algo = "hc",
  R = 20,
  returnNet = FALSE,
  algorithm.args = NULL,
  bypassConverting = FALSE,
  edgeLink = FALSE,
  pathNum = NULL,
  convertSymbol = TRUE,
  expRow = "ENSEMBL",
  interactive = FALSE,
  cexCategory = 1,
  cl = NULL,
  showDir = FALSE,
  chooseDir = FALSE,
  scoreType = "bic-g",
  labelSize = 4,
  layout = "nicely",
  clusterAlpha = 0.2,
  strType = "normal",
  delZeroDegree = TRUE,
  otherVar = NULL,
  otherVarName = NULL,
  onlyDf = FALSE,
  disc = FALSE,
  tr = NULL,
  remainCont = NULL,
  sp = "hsapiens",
  compareRef = FALSE,
  compareRefType = "intersection",
  pathDb = "reactome",
  dep = NULL,
  depMeta = NULL,
  sizeDep = FALSE,
  showDepHist = TRUE,
  cellLineName = "5637_URINARY_TRACT",
  showLineage = FALSE,
  orgDb = org.Hs.eg.db,
  shadowText = TRUE,
  bgColor = "white",
  textColor = "black",
  strengthPlot = FALSE,
  nStrength = 10,
  strThresh = NULL,
  hub = NULL,
  seed = 1,
  useSiGN = FALSE
)
}
\arguments{
\item{results}{the enrichment analysis result}

\item{exp}{gene expression matrix}

\item{expSample}{candidate samples to be included in the inference
default to all}

\item{algo}{structure learning method used in boot.strength()
default to "hc"}

\item{R}{the number of bootstrap}

\item{returnNet}{whether to return the network}

\item{algorithm.args}{parameters to pass to bnlearn
structure learnng function}

\item{bypassConverting}{bypass the symbol converting
If you use custom annotation databases that 
does not have SYMBOL listed in keys.
ID of rownames and those listed in EA result
must be same.}

\item{edgeLink}{use geom_edge_link() instead of geom_edge_diagonal()}

\item{pathNum}{the pathway number
(the number of row of the original result,
 ordered by p-value)}

\item{convertSymbol}{whether the label of resulting network is 
converted to symbol, default to TRUE}

\item{expRow}{the type of the identifier of rows of expression matrix}

\item{interactive}{whether to use bnviewer (default to FALSE)}

\item{cexCategory}{scaling factor of size of nodes}

\item{cl}{cluster object from parallel::makeCluster()}

\item{showDir}{show the confidence of direction of edges}

\item{chooseDir}{if undirected edges are present,
choose direction of edges (default: FALSE)}

\item{scoreType}{score type to use on choosing direction}

\item{labelSize}{the size of label of the nodes}

\item{layout}{ggraph layout, default to "nicely"}

\item{clusterAlpha}{if specified multiple pathways,
the parameter is passed to geom_mark_hull()}

\item{strType}{"normal" or "ms" for multiscale implementation}

\item{delZeroDegree}{delete zero degree nodes}

\item{otherVar}{other variables to be included in the inference}

\item{otherVarName}{the names of other variables}

\item{onlyDf}{return only data.frame used for inference}

\item{disc}{discretize the expressoin data}

\item{tr}{Specify data.frame if one needs to discretize
as the same parametersas the other dataset}

\item{remainCont}{Specify characters when perform discretization,
if some columns are to be remain continuous}

\item{sp}{query to graphite::pathways(), default to "hsapiens"}

\item{compareRef}{whether compare to the reference network}

\item{compareRefType}{"intersection" or "difference"}

\item{pathDb}{query to graphite::pathways(), default to "reactome"}

\item{dep}{the tibble storing dependency score from library depmap}

\item{depMeta}{depmap::depmap_metadata(), needed for showLineage}

\item{sizeDep}{whether to reflect DepMap score to the node size}

\item{showDepHist}{whether to show depmap histogram}

\item{cellLineName}{the cell line name to be included}

\item{showLineage}{show the dependency score across the lineage}

\item{orgDb}{perform clusterProfiler::setReadable
based on this organism database}

\item{shadowText}{whether to use shadow text for the better readability
default: TRUE}

\item{bgColor}{color for text background when shadowText is TRUE}

\item{textColor}{color for text when shadowText is TRUE}

\item{strengthPlot}{append the barplot depicting edges with high strength}

\item{nStrength}{specify how many edges are included in the strength plot}

\item{strThresh}{the threshold for strength}

\item{hub}{visualize the genes with top-n hub scores}

\item{seed}{A random seed to make the analysis reproducible, default is 1.}

\item{useSiGN}{default to FALSE.
For using SiGN-BN in the function in Windows 10/11,
1. Download the SiGN-BN HC+BS binary in WSL
(https://sign.hgc.jp/signbn/download.html)
2. Set PATH to executable (sign.1.8.3)}
}
\value{
ggplot2 object
}
\description{
Plot gene relationship within the specified pathway
}
\examples{
data("exampleEaRes");data("exampleGeneExp")
res <- bngeneplot(results = exampleEaRes, exp = exampleGeneExp, pathNum = 1,
                  R = 10, convertSymbol = TRUE, expRow = "ENSEMBL")

}
