% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnpathplotCustom.R
\name{bnpathplotCustom}
\alias{bnpathplotCustom}
\title{bnpathplotCustom}
\usage{
bnpathplotCustom(
  results,
  exp,
  expSample = NULL,
  algo = "hc",
  R = 20,
  expRow = "ENSEMBL",
  color = "p.adjust",
  cexCategory = 1,
  cl = NULL,
  showDir = FALSE,
  chooseDir = FALSE,
  labelSize = 4,
  layout = "nicely",
  strType = "normal",
  compareRef = FALSE,
  disc = FALSE,
  tr = NULL,
  remainCont = NULL,
  qvalueCutOff = NULL,
  adjpCutOff = 0.05,
  nCategory = 15,
  cexLine = 1,
  returnNet = FALSE,
  dep = NULL,
  sizeDep = FALSE,
  cellLineName = "5637_URINARY_TRACT",
  fontFamily = "sans",
  otherVar = NULL,
  otherVarName = NULL,
  onlyDf = FALSE,
  algorithm.args = NULL,
  strengthPlot = FALSE,
  nStrength = 10,
  edgeLink = FALSE,
  strThresh = NULL,
  hub = NULL,
  glowEdgeNum = NULL,
  nodePal = c("blue", "red"),
  edgePal = c("blue", "red"),
  textCol = "black",
  backCol = "white",
  barTextCol = "black",
  barPal = c("red", "blue"),
  barBackCol = "white",
  scoreType = "bic-g",
  barLegendKeyCol = "white",
  orgDb = org.Hs.eg.db,
  barAxisCol = "black",
  barPanelGridCol = "black",
  bg.colour = NULL,
  bg.r = 0.1,
  seed = 1,
  bypassConverting = FALSE
)
}
\arguments{
\item{results}{the enrichment analysis result}

\item{exp}{gene expression matrix}

\item{expSample}{candidate rows to be included in the inference
default to all}

\item{algo}{structure learning method used in boot.strength()
default to "hc"}

\item{R}{the number of bootstrap}

\item{expRow}{the type of the identifier of rows of expression matrix}

\item{color}{color of node, default to adjusted p-value}

\item{cexCategory}{scaling factor of size of nodes}

\item{cl}{cluster object from parallel::makeCluster()}

\item{showDir}{show the confidence of direction of edges}

\item{chooseDir}{if undirected edges are present, choose direction of edges}

\item{labelSize}{the size of label of the nodes}

\item{layout}{ggraph layout, default to "nicely"}

\item{strType}{"normal" or "ms" for multiscale implementation}

\item{compareRef}{whether compare to the reference network between pathway}

\item{disc}{discretize the expressoin data}

\item{tr}{Specify data.frame if one needs to discretize
as the same parameters as the other dataset}

\item{remainCont}{Specify characters when perform discretization,
if some columns are to be remain continuous}

\item{qvalueCutOff}{the cutoff value for qvalue}

\item{adjpCutOff}{the cutoff value for adjusted pvalues}

\item{nCategory}{the number of pathways to be included}

\item{cexLine}{scaling factor of width of edges}

\item{returnNet}{whether to return the network}

\item{dep}{the tibble storing dependency score from library depmap}

\item{sizeDep}{whether to reflect DepMap score to the node size}

\item{cellLineName}{the cell line name to be included}

\item{fontFamily}{font family name to be used for plotting}

\item{otherVar}{other variables to be included in the inference}

\item{otherVarName}{the names of other variables}

\item{onlyDf}{return only data.frame used for inference}

\item{algorithm.args}{parameters to pass to
bnlearn structure learnng function}

\item{strengthPlot}{append the barplot depicting edges with high strength}

\item{nStrength}{specify how many edges are included in the strength plot}

\item{edgeLink}{use geom_edge_link() instead of geom_edge_diagonal()}

\item{strThresh}{threshold for strength, automatically determined if NULL}

\item{hub}{change the shape of node according to hub scores (default NULL)}

\item{glowEdgeNum}{edges with top-n confidence of direction are highlighted}

\item{nodePal}{vector of coloring of nodes (low, high)}

\item{edgePal}{vector of coloring of edges (low, high)}

\item{textCol}{color of texts in network plot}

\item{backCol}{color of background in network plot}

\item{barTextCol}{text color in barplot}

\item{barPal}{bar color}

\item{barBackCol}{background color in barplot}

\item{scoreType}{score type to use on inference}

\item{barLegendKeyCol}{legend key color in barplot}

\item{orgDb}{perform clusterProfiler::setReadable
based on this organism database}

\item{barAxisCol}{axis color in barplot}

\item{barPanelGridCol}{panel grid color in barplot}

\item{bg.colour}{parameter to pass to geom_node_text}

\item{bg.r}{parameter to pass to geom_node_text}

\item{seed}{A random seed to make the analysis reproducible, default is 1.}

\item{bypassConverting}{bypass the symbol converting
ID of rownames and those listed in EA result
must be same}
}
\value{
ggplot2 object
}
\description{
Plot pathway relationship using customized theme
}
\examples{
data("exampleEaRes");data("exampleGeneExp")
res <- bnpathplotCustom(results=exampleEaRes, exp=exampleGeneExp,
                        fontFamily="sans", glowEdgeNum=3, hub=3)
}
