% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{queryCpDistLw}
\alias{queryCpDistLw}
\title{queryCpDistLw}
\usage{
queryCpDistLw(
  fitted,
  candidate,
  evidence,
  levels,
  point = FALSE,
  pointSize = 5,
  alpha = TRUE,
  ...
)
}
\arguments{
\item{fitted}{bn.fit object}

\item{candidate}{name of node}

\item{evidence}{evidence variable name}

\item{levels}{level to be listed}

\item{point}{geom_point the weighted mean}

\item{pointSize}{point size for geom_point}

\item{alpha}{whether to reflect the weights by alpha (TRUE) or color (FALSE)}

\item{...}{other parameters passed to bnlearn cpdist}
}
\value{
list of dataframe containing raw values
}
\description{
produce a plot of bnlearn::cpdist by performing bnlearn::cpdist
on specified node, evidence and level.
}
\examples{
library(bnlearn)
data("exampleEaRes")
data("exampleGeneExp")
net <- bngeneplot(exampleEaRes, exampleGeneExp,
                  pathNum=1, returnNet=TRUE)
fitted <- bn.fit(net$av, net$df)
res <- queryCpDistLw(fitted, candidate="ERCC4", evidence="ERCC2",
                     levels=c(0.1, 0.5, 0.8), n=500)
}
