% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils_CHETAH.R
\name{ClassifyReference}
\alias{ClassifyReference}
\title{Use a reference dataset to classify itself.
A good reference should have almost no mixture
between reference cells.}
\usage{
ClassifyReference(
  ref_cells,
  ref_ct = "celltypes",
  ref_c = "counts",
  return = FALSE,
  ...
)
}
\arguments{
\item{ref_cells}{the reference, similar to
\code{\link{CHETAHclassifier}}'s ref_cells}

\item{ref_ct}{the colData of \code{ref_cells} where the cell types are stored.}

\item{ref_c}{same as \code{input_c}, but for the reference.}

\item{return}{return the matrix that was used to produce the plot}

\item{...}{Other variables to pass to
\code{\link{CHETAHclassifier}}}
}
\value{
A square plot. The rows are the original cell types,
the columns the classifion labels.
The colors and sizes of the squares indicate which
part of the cells of the rowname type are
classified to the type of the column name.
On the left of the plot, the percentage of cells
that is classified to an intermediate type
is plotted.
A good reference would classify nearly 100% of cells of type A to type A.
}
\description{
Use a reference dataset to classify itself.
A good reference should have almost no mixture
between reference cells.
}
\examples{
data('headneck_ref')
ClassifyReference(ref_cells = headneck_ref)
}
