% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils_CHETAH.R
\name{PlotTSNE}
\alias{PlotTSNE}
\title{Plots a variable on a t-SNE}
\usage{
PlotTSNE(
  toplot,
  input,
  redD = NA,
  col = NULL,
  return = FALSE,
  limits = NULL,
  pt.size = 1,
  shiny = NULL,
  y_limits = NULL,
  x_limits = NULL,
  legend_label = ""
)
}
\arguments{
\item{toplot}{the variable that should be plotted. Either a character vector
or a factor, or a (continuous) numeric.
If toplot is not named with the rownames of \code{redD}, it is assumed
that the order of the two is the same.}

\item{input}{a SingleCellExperiment on which \code{\link{CHETAHclassifier}} has been run}

\item{redD}{the name of the reducedDim of the input to use for plotting}

\item{col}{a vector of colors. If \code{toplot} is a numeric,
this will become a continuous scale. \cr
\emph{If \code{toplot} is a charachter vector, the colors should
be named with the unique values (/levels) of toplot}}

\item{return}{instead of printing, return the ggplot object}

\item{limits}{the limits of the continuous variable to plot.
When not provided the minimal and maximal value will be used}

\item{pt.size}{the point-size}

\item{shiny}{Needed for the shiny application: should always be NULL}

\item{y_limits}{the y-axis limits}

\item{x_limits}{the x-axis limits, if NULL}

\item{legend_label}{the label of the legend}
}
\value{
A ggplot object
}
\description{
Plots a variable on a t-SNE
}
\examples{
data('input_mel')
CD8 <- assay(input_mel)['CD8A', ]
PlotTSNE(toplot = CD8, input = input_mel)
}
