% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils_CHETAH.R
\name{PlotTree}
\alias{PlotTree}
\title{Plots the chetah classification tree with nodes numbered}
\usage{
PlotTree(
  input,
  col = NULL,
  col_nodes = NULL,
  return = FALSE,
  no_bgc = FALSE,
  plot_limits = c(-0.4, 0.1),
  labelsize = 6
)
}
\arguments{
\item{input}{a SingleCellExperiment on which \code{\link{CHETAHclassifier}} has been run}

\item{col}{a vector of colors, with the names of the reference cell types}

\item{col_nodes}{a vector of colors, ordered for node 1 till the last node}

\item{return}{instead of printing, return the ggplot object}

\item{no_bgc}{remove the background color from the node numbers}

\item{plot_limits}{define the % of the plot_heigth that should be used as a margin below and above the plot
Decreasing the former further is usefull when the labels are cut of the plot (default = c(-0,25, 01)).}

\item{labelsize}{the size of the intermediate and leaf node labels (default = 6)}
}
\value{
A ggplot object of the classification tree
}
\description{
Plots the chetah classification tree with nodes numbered
}
\examples{
data('input_mel')
PlotTree(input = input_mel)
}
