% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatasetGenerator.R
\name{finalize_generator}
\alias{finalize_generator}
\title{Finalize generator normalizing edge weights}
\usage{
finalize_generator(generator)
}
\arguments{
\item{generator}{a generator}
}
\value{
A generator with edge weights that respect DTMC definition
}
\description{
Checks if a generator can be normalized so that it 
actually is a Markov Chain
}
\examples{
require(dplyr)

example_dataset() \%>\%
 make_generator_stub() \%>\% 
 set_generator_edges(
   list(
    "D", "A, D", 1 , 
    "A", "A, D", 1 , 
    "A, D", "A, C, D", 1 , 
    "A, D", "A, B, D", 1 , 
    "Clonal", "D", 1 , 
    "Clonal", "A", 1 , 
    "D", "D", 1 , 
    "A", "A", 1 , 
    "A, D", "A, D", 1 , 
    "A, C, D", "A, C, D", 1 , 
    "A, B, D", "A, B, D", 1 , 
    "Clonal", "Clonal", 1 
  )) \%>\% 
  finalize_generator

}
