% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_fluo_NBE.R
\name{reestimate.pseudos.byCV}
\alias{reestimate.pseudos.byCV}
\title{reestimate.pseudos.byCV}
\usage{
reestimate.pseudos.byCV(data, diff.quantile, perc.cutoff,
  pseudotime.cutoff)
}
\arguments{
\item{data}{Numeric. A vector of estimated pseudotimes for one sample. The first value corresponds to the estimate
of the whole data. The second value is the difference between the estimate of the original data and the median
of the CV-estimated pseudotimes and it is used as a dissimilarity measure. The rest of the values are the CV estimated
pseudotimes themselves.}

\item{diff.quantile}{Float. The qth quantile of the distribution of the difference between the original and the CV-estimated
pseudotimes. The q parameter is defined in Fluo_CV_modeling().}

\item{perc.cutoff}{Float. The percentage of CV-estimated pseudotimes that are similar (clustered together by k-means)}

\item{pseudotime.cutoff}{Integer. A user-defined value to define outlier samples, i.e. samples with Pseudotime(original) -
median{Pseudotime(CV)} > pseudotime.cutoff.}
}
\value{
It summarizes the CV-estimated pseudotimes into a single value. There are three possible methods that may produce
  different results. For details see parameter pseudo.est.method at Fluo_CV().
}
\description{
It estimates a new pseudotime for each sample based on its cross-validation estimates.
}
\keyword{internal}
