% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lasso_PI_scores_f.R
\name{Lasso_PI_scores_f}
\alias{Lasso_PI_scores_f}
\title{Lasso-Based Prognostic Index Calculation}
\usage{
Lasso_PI_scores_f(
  train_data,
  test_data,
  nfolds,
  col_num,
  surv_time,
  surv_event
)
}
\arguments{
\item{train_data}{A data frame containing the training data, including
survival time, event status, and features.}

\item{test_data}{A data frame containing the test data, including survival
time, event status, and features.}

\item{nfolds}{An integer specifying the number of cross-validation folds
for LASSO.}

\item{col_num}{An integer indicating the starting column index for the
feature variables.}

\item{surv_time}{A character string specifying the column name for
survival time in the data.}

\item{surv_event}{A character string specifying the column name for
survival event status in the data.}
}
\value{
A list with the following components:
\itemize{
\item \code{Train_Lasso_key_variables}: A data frame of selected key
variables and their coefficients.
\item \code{Train_PI_data}: A data frame with training data, including
survival time, event status, and PI.
\item \code{Test_PI_data}: A data frame with test data, including
survival time, event status, and PI.
\item \code{cvfit}: A \code{cv.glmnet} object representing the fitted LASSO
Cox model.
}
}
\description{
Lasso-Based Prognostic Index Calculation
}
\details{
The function first checks the validity of input data. It renames
the survival time and event columns in the training and test datasets,
then fits a Cox proportional hazards model using Lasso regularization
via cross-validation. Based on the Lasso model, the function calculates
the prognostic index (PI) for both the training and test datasets,
appending the PI values to the original data frames.
}
\examples{
data(Train_Norm_data, package = "CPSM")
data(Test_Norm_data, package = "CPSM")
Result_PI <- Lasso_PI_scores_f(
train_data = Train_Norm_data,
test_data = Test_Norm_data,
nfolds = 5,
col_num = 21,
surv_time = "OS_month",
surv_event = "OS")

}
