% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{basicHeatmap}
\alias{basicHeatmap}
\title{Plot a simple heatmap}
\usage{
basicHeatmap(
  mat,
  aesNames = c("x", "y", "Score"),
  title = "Heatmap",
  axisTextSize = 7,
  palType = "fillCont",
  wesPal = "Royal1",
  wesLow = 3,
  wesHigh = 2,
  ...
)
}
\arguments{
\item{mat}{A matrix.}

\item{aesNames}{A character vector of length 3 representing the y, x and fill
aes elements.}

\item{title}{Plot title.}

\item{axisTextSize}{Axis text size.}

\item{palType}{Palette type: color or fill, continuous or discrete. Accepted
values are 'colorCont', 'fillCont', 'colDis' and 'fillDis'. The function
shows a warning and does not change the color scheme if a different value
is passed here.}

\item{wesPal}{A wesanderson palette.}

\item{wesLow}{Index of color marking low values.}

\item{wesHigh}{Index of color marking high values.}

\item{...}{Other arguments passed to \code{henna::centerTitle}.}
}
\value{
A ggplot object.
}
\description{
This function plots a simple heatmap, with clustering but no dendograms.
}
\examples{
mat <- matrix(0, 10, 20)
mat[sample(length(mat), 50)] <- runif(50, max = 2.5)
basicHeatmap(mat)

}
