% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_filter.R
\name{breakWeakTies}
\alias{breakWeakTies}
\title{Remove overlap pairs with low Jaccard scores}
\usage{
breakWeakTies(
  overlapDF,
  cutoff = 1/3,
  doConnComp = FALSE,
  mtMethod = c("BY", "BH")
)
}
\arguments{
\item{overlapDF}{An overlap data frame.}

\item{cutoff}{A cutoff used in the filtering of edges with low Jaccard
scores.}

\item{doConnComp}{Whether to calculate the connected components.}

\item{mtMethod}{Multiple testing correction method. Choose between
Benjamini-Yekutieli ('BY') and Benjamini-Hochberg('BH').}
}
\value{
An overlap data frame in which edges with low Jaccard scores have
been removed.
}
\description{
This function iteratively removes all overlap pairs with neighbor Jaccard
score below a fixed cutoff until no overlap pairs can be removed.
Subsequently, overlap ranks are recalculated.
}
\details{
The functions removes overlaps for which the two involved genes
record too few shared neighbors—genes whose cell set significantly overlaps with
those of both overlap genes.
}
\examples{
overlapDF <- data.frame(gene1=paste0('G', c(1, 3, 7, 6, 8, 2, 4, 3, 4, 5)),
gene2=paste0('G', c(2, 7, 2, 5, 4, 5, 1, 2, 2, 8)),
ratio=runif(10, 2, 10),
pval=runif(10, 0, 1e-10))
breakWeakTies(overlapDF, cutoff=0.1)

}
