% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocessData}
\alias{preprocessData}
\title{Wrapper function to preprocess the data}
\usage{
preprocessData(
  inputRegions,
  sampleInfoFile,
  sampleDir = ".",
  inputCountData,
  numClusters = 4,
  noNeg = TRUE,
  plotDataToPDF = FALSE,
  ...
)
}
\arguments{
\item{inputRegions}{A bed file  the regions to analyze.}

\item{sampleInfoFile}{A tab separated file  all sample information. 
The following are the columns that are present in the file. 
* Sample Name : Names for the samples. 
* Group : The group the sample belongs.
* IP : The name of the sample bam file. 
* IP_aligned_reads : The number of aligned reads in the sample. This is used
in depth normalization process.
* IN : The name of the sample's control bam file.
* IN_aligned_reads : The number of aligned reads in the control file. This 
is used in depth normalization process.}

\item{sampleDir}{Location of the input sample files in `sampleInfoFile` file.
(default: ".")
Name,Group/Label,IP bam location,IP number of reads,IN bam location,
IN number of reads).}

\item{inputCountData}{The path to the file  count data. This parameter 
is used when directly loading count data from a file. This should be a tab 
separated file  sample names as header.}

\item{numClusters}{A numerical parameter indicating the number of clusters 
to use in the normalization step. Passed on to \code{\link{normalizeData}}.
(default: 4)}

\item{noNeg}{A logical parameter indicating how to deal  negative 
values. It is passed to \code{\link{ansTransform}}. (default: TRUE)}

\item{plotDataToPDF}{A logical parameter indicating whether to make plots of the 
data distribution to a separate PDF file for each sample.
It is passed on to passed to \code{\link{ansTransform}}.
(default: FALSE)}

\item{...}{Additional arguments passed on to \code{\link{getRegionCounts}}.}
}
\value{
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}}
containing the normalized counts, cluster information, the variance of the 
cluster in the sample and metadata.
}
\description{
This is a wrapper function that calls the functions to preprocess the data.
It results in a 
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}} object
 normalized counts and meta data that can be used by  
\code{\link{DBAnalyze}}.
}
\examples{
processedData <- preprocessData(system.file("extdata", "chr19_regions.bed",
package="CSSQ"),system.file("extdata", "sample_info.txt", package="CSSQ"),
sampleDir = system.file("extdata", package="CSSQ"),
numClusters=4,noNeg=TRUE,plotDataToPDF=FALSE)
processedData
}
\seealso{
\code{\link{getRegionCounts}}, \code{\link{ansTransform}} and 
\code{\link{normalizeData}} which this function calls
}
