% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTSV.R
\name{CTSV}
\alias{CTSV}
\title{Detection of cell-type-specific spatially variable genes}
\usage{
CTSV(spe, W, num_core = 1, BPPARAM = NULL)
}
\arguments{
\item{spe}{A SpatialExperiment class.}

\item{W}{A n by K cell-type proportion matrix, where K is the number of cell types. The column names of W are cell type names.}

\item{num_core}{Number of cores if using paralleling. The default is one.}

\item{BPPARAM}{Optional additional argument for parallelization. The default is NULL, in which case \code{num_core} will be used. If provided, this should be an instance of \code{BiocParallelParam}. For most users, the recommended option is to use the \code{num_core} argument.}
}
\value{
A list with a G by 2K matrix of p-values and a G by 2K matrix of q-values.
\item{pval}{A G by 2K matrix of p-values. The first K columns correspond to the first coordinate, and the last K columns to the second coordinate.}
\item{qval}{A G by 2K matrix of q-values. The first K columns correspond to the first coordinate, and the last K columns to the second coordinate.}
}
\description{
Detection of cell-type-specific spatially variable genes
}
\examples{
library(CTSV)
#read example data
data(CTSVexample_data)
spe <- CTSVexample_data[[1]]
W <- CTSVexample_data[[2]]
gamma_true <- CTSVexample_data[[3]]
# gene number
G <- nrow(spe)
# spot number
n <- ncol(spe)
# cell type number
K <- ncol(W)
G
n
K
# SV genes in each cell type:
rownames(W)[which(gamma_true[,1] == 1)]
rownames(W)[which(gamma_true[,2] == 1)]
# Number of SV genes at the aggregated level:
sum(rowSums(gamma_true)>0)
#--- Run CTSV ----
result <- CTSV(spe,W,num_core = 8)
# View on q-value matrix
head(result$qval)
# detect SV genes
re <- svGene(result$qval,0.05)
#SV genes in each cell type:
re$SVGene
}
