% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{HPA_cell_type_specificities}
\alias{HPA_cell_type_specificities}
\title{Cell type specificities (from HPA)}
\format{
A \code{tibble} object with 24504 rows and 7 columns.
\itemize{
\item Rows correspond to genes (ensembl_gene_id)
\item Columns give genes cell type specificities
}
}
\source{
\code{proteinatlas.tsv} was downloaded from the Human Protein Atlas
(https://www.proteinatlas.org)
See \code{scripts/make_HPA_cell_type_specificities.R} for details.
}
\description{
Cell type specificities based on scRNAseq data from the
Human Protein Atlas (https://www.proteinatlas.org)
}
\details{
\itemize{
\item Column \code{HPA_scRNAseq_celltype_specific_nTPM} gives the cell types in
which genes were detected (corresponds to column
\verb{RNA single cell type specific nTPM} of proteinatlas.tsv file.
\item Column \code{max_HPA_germcell} specifies if the maximum expression value in a
germ cell type
\item Column \code{max_HPA_somatic} specifies if the maximum expression value in a
somatic cell type
\item Column \code{not_detected_in_somatic_HPA} specifies if the gene is detected or
not in a somatic cell type. Genes are flagged as
\code{TRUE} if the \code{max_HPA_somatic} value is equal to 0, and \code{FALSE} if
\code{max_HPA_somatic} value is > 0. \code{NA} is set when the original table from HPA
had no values for that gene.
\item Column \code{HPA_ratio_germ_som} gives the ratio between \code{max_HPA_germcell} and
\code{max_HPA_somatic} columns.
}
}
