% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mean_methylation_in_FGC}
\alias{mean_methylation_in_FGC}
\title{All genes' promoters mean methylation in FGC}
\format{
A \code{RangedSummarizedExperiment} object with 24441 rows and 337 columns
\itemize{
\item Rows correspond to all genes (gene names as rownames)
\item Mean methylation levels in FGC types are stored in columns
\item rowRanges correspond to the hg19 promoter positions
}
}
\source{
WGBS methylation data was downloaded from GEO. Mean methylation levels are
evaluated using methylation values of CpGs located in promoter region
(defined as 1000 nt upstream TSS and 500 nt downstream TSS) (see
\code{scripts/make_mean_methylation_in_FGC.R} for details).
}
\description{
Mean methylation values of all CpGs located within all genes
promoters in fetal germ cells. Data is based on hg19 reference genome ! From
\verb{Dissecting the epigenomic dynamics of human fetal germ cell development at single-cell resolution (Li et al. 2021)}
}
\details{
The rowData contains:
\itemize{
\item A column named \code{ensembl_gene_id} containing gene ids.
}
}
