% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_data_preprocessing.R
\name{readMultipleTables}
\alias{readMultipleTables}
\title{Read folder of files in different table input formats (xlsx, csv or txt).}
\usage{
readMultipleTables(dataFolder, fileType, concCol, measCol, ...)
}
\arguments{
\item{dataFolder}{\strong{character(1)} \cr Folder containing either xlsx, csv or
txt files}

\item{fileType}{\strong{character(1)} \cr Type of file: "csv", "txt" or "xlsx".}

\item{concCol}{\strong{integer(1)} \cr Column number of the concentration values.}

\item{measCol}{\strong{integer} \cr Column number of the concentration values.}

\item{...}{additional parameters to \code{\link{readDataTable}}}
}
\value{
List of data.frame, each with two numeric columns:
Concentration and Measurement
}
\description{
Read folder of files in different table input formats (xlsx, csv or txt).
}
\examples{
data_folder <- system.file("extdata", "MSQC1_xlsx",
    package = "CalibraCurve")
D_list <- readMultipleTables(
    dataFolder = data_folder, fileType = "xlsx",
    concCol = 16, measCol = 12
)
}
