% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeneAnnotation.R
\name{predictGeneAnnotationImpl}
\alias{predictGeneAnnotationImpl}
\title{This function is the implementation for predicting
the functions of a gene based on the functions of its
neighbours.}
\usage{
predictGeneAnnotationImpl(
  gene,
  fPrime,
  genesAnno,
  radius,
  metric,
  numPCs = NULL,
  normaliseByDistance = TRUE
)
}
\arguments{
\item{gene}{\itemize{
\item gene to annotate
}}

\item{fPrime}{\itemize{
\item a Seurat object of genes or
SingleCellExperiment to be converted to a Seurat object
}}

\item{genesAnno}{\itemize{
\item genes annotated with gene sets
}}

\item{radius}{\itemize{
\item radius of neighbours to consider
}}

\item{metric}{\itemize{
\item which metric to use to discover
neighbours, can be one of 'umap', 'tsne', 'pca', 'NN',
defaults to umap
}}

\item{numPCs}{\itemize{
\item used only if metric is pca. Defaults to NULL
}}

\item{normaliseByDistance}{\itemize{
\item choose whether to normalise
contributions of neighbors by their distance, defaults to
TRUE
}}
}
\value{
This returns a named list.  The names are
the anotations that apply to the neighbour genes, the values
are the relative wieghts of the contributions.
}
\description{
This function is the implementation for predicting
the functions of a gene based on the functions of its
neighbours.
}
\examples{
getExample = make.getExample()
STranspose = getExample('STranspose',toy=TRUE)
hallmark = getExample('hallmark',toy=TRUE)
genesAnno = annotateGenesByGeneSet(hallmark)
predictions = predictGeneAnnotationImpl('Myc',STranspose,genesAnno,
radius=.5,metric='umap')
}
