% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnalysePredictionsList.r
\name{AnalysePredictionsList}
\alias{AnalysePredictionsList}
\title{analyse predictions list}
\usage{
AnalysePredictionsList(predictionsList, numPredictions)
}
\arguments{
\item{predictionsList}{list of predictions}

\item{numPredictions}{number of predictions}
}
\value{
prediction statistics
}
\description{
Taking the list of predictions from a particular hypothesis, counts the number of
positive and negative predictions in the list and the number of 0's (from numPredictions).
}
\examples{
network <- system.file(package='CausalR', 'extdata', 'testNetwork.sif')
ccg <- CreateCCG(network)
predictions <- MakePredictions('NodeA', +1, ccg, 2)
AnalysePredictionsList(predictions,8)
}
\concept{
CausalR
}

