% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompareHypothesis.r
\name{CompareHypothesis}
\alias{CompareHypothesis}
\title{compare hypothesis}
\usage{
CompareHypothesis(matrixOfPredictions, matrixOfExperimentalData, ccg = NULL,
  sourceNode = NULL)
}
\arguments{
\item{matrixOfPredictions}{a matrix of predictions}

\item{matrixOfExperimentalData}{a matrix of experimental data}

\item{ccg}{a CCG network (default=NULL)}

\item{sourceNode}{A starting node (default=NULL)}
}
\value{
a matrix containing predictions, observations and scores.
}
\description{
Compare the predictions from a hypothesis with the experimental data returning an matrix with columns for node ID, predictions, experimental results and the corresponding scores.
}
\examples{
predictions <- matrix(c(1,2,3,+1,0,-1),ncol=2)
experimentalData <- matrix(c(1,2,4,+1,+1,-1),ncol=2)
ScoreHypothesis(predictions,experimentalData)
CompareHypothesis(predictions,experimentalData)
}
\concept{
CausalR
}

