% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakePredictions.r
\name{MakePredictions}
\alias{MakePredictions}
\title{make predictions}
\usage{
MakePredictions(hypothesisnode, signOfHypothesis, network, delta,
  nodesInExperimentalData = NULL)
}
\arguments{
\item{hypothesisnode}{the node in the causal graph from which predictions should be made.  Can be either a (numerical) node ID or a (string) node name.}

\item{signOfHypothesis}{whether the hypothesis node is up- or down-regulated. Should be +1 or -1.}

\item{network}{a (Computational) Causal Graph, as an igraph.}

\item{delta}{the distance to search within the causal graph.}

\item{nodesInExperimentalData}{optional. Nodes to include in the output. Should be a list of node IDs.}
}
\value{
a matrix of predictions for the given particular hypothesis
}
\description{
Creates a matrix of predictions for a particular hypothesis.
The output is an array containing the relationship between each node and the hypothesis.
The hypothesis provided will be the vertex id of one of the nodes in the network
(as an integer node ID or name, including + or - for up/down regulation in the case of a CCG).
The signOfHypothesis variable should be a 1 or -1, indicating up/down regulation.
}
\examples{
network <- system.file(package='CausalR', 'extdata', 'testNetwork.sif')
ccg <- CreateCCG(network)
predictions <- MakePredictions('NodeA', +1, ccg, 2)
}
\concept{
CausalR
}

