#' List of reference genes for 5 different organisms to perform enrichment
#'
#' List with protein codings for 5 organisms that must be used as reference 
#' genes for functional enrichment. This list was generated using Ensembl GTF. 
#' The organisms are: Human (\emph{Homo sapiens}), Mouse (\emph{Mus musculus}), 
#' Zebrafish (\emph{Danio rerio}), Cow (\emph{Bos taurus}) and Rat (\emph{Rattus 
#' norvegicus}).
#'
#' @docType data
#'
#' @usage data(refGenes)
#'
#' @format An list.
#'
#' @keywords datasets
#' 
#' @references \url{https://www.ensembl.org/info/data/ftp/index.html}
#'
#' @examples
#' data(refGenes)
"refGenes"
