% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCIT.R
\name{PCIT}
\alias{PCIT}
\title{Partial Correlation and Information Theory (PCIT) analysis}
\usage{
PCIT(input, tolType = "mean")
}
\arguments{
\item{input}{A correlation matrix.}

\item{tolType}{Type of tolerance (default: 'mean') given the 3 pairwise correlations
(see \code{\link{tolerance}}).}
}
\value{
Returns an list with the significant correlations, raw adjacency matrix
and significant adjacency matrix.
}
\description{
The PCIT algorithm is used for reconstruction of gene co-expression
networks (GCN) that combines the concept partial correlation coefficient
with information theory to identify significant gene to gene associations
defining edges in the reconstruction of GCN.
}
\examples{
# loading a simulated normalized data
data('simNorm')

# getting the PCIT results for first 30 genes
results <- PCIT(simNorm[1:30, ])

# printing PCIT output first 15 rows
head(results$tab, 15)

}
\references{
REVERTER, Antonio; CHAN, Eva KF. Combining partial correlation and
an information theory approach to the reversed engineering of gene
co-expression networks. Bioinformatics, v. 24, n. 21, p. 2491-2497, 2008.
\url{https://academic.oup.com/bioinformatics/article/24/21/2491/192682}
}
