% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatPlot.R
\name{heatPlot}
\alias{heatPlot}
\title{Heatmap-like functional classification}
\usage{
heatPlot(res, diff, showCategory = 10, font_size = 6)
}
\arguments{
\item{res}{A dataframe with \code{\link{getEnrich}} results.}

\item{diff}{A dataframe with all differentialy expressed genes obtained
from \code{\link{runAnalysis}} function. For better understanding, simply
use the \code{\link{getDE}} accessor with 'all' option.}

\item{showCategory}{Number of enriched terms to display (default: 10).}

\item{font_size}{Size of gene row names (default: 6).}
}
\value{
Returns a Heatmap-like functional classification
}
\description{
Heatmap-like functional classification to visualize the 
enrichment analysis results from \code{\link{getEnrich}} function. The plot
contains the heatmap with the associated pathways genes, the significance
of the enrichment and a barplot with the enrichment ratio.
}
\examples{
# loading enrichdemo and CeTFdemo object
data(enrichdemo)
data(CeTFdemo)

heatPlot(res = enrichdemo$results, 
         diff = getDE(CeTFdemo, 'all'), 
         showCategory = 10)

}
