% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-plot_barcode.R
\name{bc_plot_count}
\alias{bc_plot_count}
\alias{bc_plot_count,BarcodeObj-method}
\title{Plot for counts distribution}
\usage{
bc_plot_count(barcodeObj, bins = 20, useCleaned = TRUE)

\S4method{bc_plot_count}{BarcodeObj}(barcodeObj, bins = 20, useCleaned = TRUE)
}
\arguments{
\item{barcodeObj}{A BarcodeObj object}

\item{bins}{The number of bins for the histogram}

\item{useCleaned}{Whether to use the cleaned barcode data}
}
\value{
A egg::ggarrange object
}
\description{
This function is used to summarize the counts of each barcode.
}
\details{
When useCleaned is TRUE, the cleaned barcode data will be used.
Otherwise, the messy barcode data will be used.
The output will be different when useCleaned is TRUE or FALSE.
It also depends on whether the UMI is available.
The counts include:
 \enumerate{
  \item reads count (with barcode) versus the total reads
 \item reads count per UMI
 \item UMI count per barcode
 \item barcode count per sample
 \item reads or UMI count (dominant barcode) versus total count per sample
 \item reads or UMI count (dominant barcode) distribution
}
}
\examples{
data(bc_obj)
bc_plot_count(barcodeObj=bc_obj)

}
