% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherMetrics.R
\name{locStructure}
\alias{locStructure}
\title{locStructure}
\usage{
locStructure(
  sce,
  group,
  dim_combined,
  k = 100,
  dim_red = "PCA",
  assay_name = "logcounts",
  n_dim = 10,
  n_combined = 10,
  res_name = NULL
)
}
\arguments{
\item{sce}{\code{SingleCellExperiment} object, with the integrated data.}

\item{group}{Character. Name of group/batch variable.
Needs to be one of \code{names(colData(sce))}.}

\item{dim_combined}{Charactyer. Name of the reduced dimensional
representation of the integrated data.
Needs to be one of \code{reducedDimNames(sce))}.}

\item{k}{Numeric. Number of k-nearest neighbours (knn) to use.}

\item{dim_red}{Character. Name of embeddings to calculate neighbourhoods
before integration. Default is "PCA".}

\item{assay_name}{Character. Name of the assay to use for PCA of the original
(not integrated) data. Should not refer to "corrected" counts.}

\item{n_dim}{Numeric. Number of dimensions to include for the original data.}

\item{n_combined}{Numeric. Number of dimensions to include for the
integrated data.}

\item{res_name}{Character. Appendix of the result score's name
(e.g. method used to combine batches).}
}
\value{
A \code{SingleCellExperiment} with the mixing metric within colData.
}
\description{
locStructure
}
\details{
The locStructure function implements the localStructure function
from Seurat (See \code{\link[Seurat]{LocalStruct}}. For each group it
calculates the k nearest neighbour within PCA space before integration and
compares it to the knn within the reduced dimensional representation after
integration. The score represents the proportion of overlapping neighbours.
The \code{\link[Seurat]{LocalStruct}} function is based on the
\code{\link[Seurat]{RunPCA}} function, while here \code{\link[scater]{runPCA}}
is used. This can cause small deviance from the
\code{\link[Seurat]{LocalStruct}} function, but overall these functions are
equivalent.
}
\examples{
library(SingleCellExperiment)
sim_list <- readRDS(system.file("extdata/sim50.rds", package = "CellMixS"))
sce <- sim_list[["batch20"]][, c(1:50, 300:350)]

sce <- locStructure(sce, "batch", "MNN", k = 20, assay_name = "counts")
}
\references{
Stuart T Butler A Hoffman P Hafemeister C Papalexi E et. al. (2019)
Comprehensive Integration of Single-Cell Data.
Cell.
}
