% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisCms.R
\name{visHist}
\alias{visHist}
\title{visHist}
\usage{
visHist(
  res_object,
  metric = "cms",
  prefix = TRUE,
  n_col = 1,
  metric_prefix = NULL
)
}
\arguments{
\item{res_object}{\code{SingleCellExperiment} object, matrix or data.frame.
The SingleCellExperiment object should contain the result scores (e.g. cms)
to plot in \code{colData(res_object)}.
Matrix or data frame should have result scores in columns and cells in rows.}

\item{metric}{Character vector. Specify names of \code{colData(sce)} to be
plotted. Applys only if `res_object` is a \code{SingleCellExperiment} object.
Default is 'cms'. If prefix is TRUE all columns starting with `metric` will
be plotted.}

\item{prefix}{Boolean. Is `metric` used to specify column's prefix(true) or
complete column names (False).}

\item{n_col}{Numeric. Number of columns of the pval histogram.}

\item{metric_prefix}{Former parameter to define prefix of the metric to be
plotted. Will stop and ask for the new syntax.}
}
\value{
a \code{ggplot} object.
}
\description{
Plot pvalue histograms of metric score distributions
}
\details{
Plots metric score distribution similar to a pvalue histogram
distribution. Without dataset-specific bias, cms scores should be approx.
flat distributed. If `res_object` is a matrix or data.frame,
it will create a histogram for each column. If `res_object` is a
\code{SingleCellExperiment} object, it will create a histogram of all
\code{colData(res_object)} that start with or are specified in `metric`.
}
\examples{
library(SingleCellExperiment)
sim_list <- readRDS(system.file("extdata/sim50.rds", package = "CellMixS"))
sce <- sim_list[[1]][, c(1:50)]
sce_cms <- cms(sce, "batch", k = 20, n_dim = 2)
visHist(sce_cms)


}
\seealso{
Other visualize metric functions: 
\code{\link{visMetric}()},
\code{\link{visOverview}()}
}
\concept{visualize metric functions}
