% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmsSummary.R
\name{visIntegration}
\alias{visIntegration}
\title{visIntegration}
\usage{
visIntegration(
  res_object,
  metric = "cms",
  prefix = TRUE,
  violin = FALSE,
  metric_name = "metric",
  metric_prefix = NULL
)
}
\arguments{
\item{res_object}{\code{SingleCellExperiment} object, list, matrix or
data.frame. The SingleCellExperiment object should contain the result scores
(cms) to compare within \code{colData(res_object)}. List, matrix or data
frame should have result scores in list elements resp. columns.}

\item{metric}{Character vector. Specify names of \code{colData(sce)} to be
compared. Applys only if `res_object` is a \code{SingleCellExperiment}
object. Default is 'cms'. If prefix is TRUE all columns starting with
`metric` will be compared and plotted.}

\item{prefix}{Boolean. Is `metric` used to specify column's prefix(true) or
complete column names (False).}

\item{violin}{A logical. If true violin plots are plotted,
while the default (FALSE) will plot ridge plots.}

\item{metric_name}{Character. Name of the score metric.}

\item{metric_prefix}{Former parameter to define prefix of the metric to be
plotted. Will stop and ask for the new syntax.}
}
\value{
a \code{ggplot} object.
}
\description{
Creates a summary plot of metric scores (for different integration methods).
}
\details{
Plots summarized cms scores from an \code{SingleCellExperiment}
object, list or dataframe. This function is intended to visualize and
compare different methods and views of the same dataset, not to compare
different datasets.
}
\examples{
library(SingleCellExperiment)

sim_list <- readRDS(system.file("extdata/sim50.rds", package = "CellMixS"))

sce <- sim_list[["batch20"]][, c(1:30,300:320)]
sce_mnn <- cms(sce,"batch", k = 20, dim_red = "MNN", res_name = "MNN",
n_dim = 2)

visIntegration(sce_mnn, metric = "cms.", violin = TRUE)

}
\seealso{
\code{\link{visCluster}}, \code{ggridges}
}
\concept{visualize  functions}
