% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{DimPlotMC}
\alias{DimPlotMC}
\title{Seurat DimPlot for MCA like Dimensionality Reduction}
\usage{
DimPlotMC(
  X,
  reduction = "mca",
  dims = c(1, 2),
  features = NULL,
  size.feature = 2,
  size.feature.text = 5,
  as.text = FALSE,
  ...
)
}
\arguments{
\item{X}{a Seurat object}

\item{reduction}{Which dimensionality reduction to use. If not specified, searches for mca.}

\item{dims}{Dimensions to plot, must be a two-length numeric vector specifying x- and y-dimensions}

\item{features}{character vector of features to plot, must be present in the specified dimension loadings}

\item{size.feature}{integer indicating size of geom_point for features}

\item{size.feature.text}{integer indicating size of geom_text for features}

\item{as.text}{logical indicating as to include text label for feature plotting, will produce warning if TRUE and length(features) > 50}

\item{...}{Other arguments passed to DimPlot}
}
\value{
A ggplot object
}
\description{
Small modification of the regular Seurat DimPlot function to enable plotting features for mca like dimensionality reduction.
Allows to represent a set of genes of interest on top of the regular cell scatter plot. 
The label of the genes can be iverlayed also but it is recommended to plot less than 50 genes label as it can overcrowd the plot severely.
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
seuratPbmc <- DimPlotMC(seuratPbmc, features = Seurat::VariableFeatures(seuratPbmc))
}
