% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell.R
\name{GetCellGeneSet}
\alias{GetCellGeneSet}
\alias{GetCellGeneSet.Seurat}
\alias{GetCellGeneSet.SingleCellExperiment}
\title{Gene sets extraction from MCA}
\usage{
GetCellGeneSet(X, reduction = "mca", dims, features, cells, n.features)

\method{GetCellGeneSet}{Seurat}(
  X,
  reduction = "mca",
  dims = seq(50),
  features = NULL,
  cells = NULL,
  n.features = 200
)

\method{GetCellGeneSet}{SingleCellExperiment}(
  X,
  reduction = "MCA",
  dims = seq(50),
  features = NULL,
  cells = NULL,
  n.features = 200
)
}
\arguments{
\item{X}{Seurat or SingleCell Experiment Object}

\item{reduction}{Which dimensionality reduction to use, must be based on MCA.}

\item{dims}{A vector of integers indicating which dimensions to use with reduction embeddings and loadings for distance calculation.}

\item{features}{Character vector of feature names to subset feature coordinates. If not specified will take all features available from specified reduction Loadings}

\item{cells}{Character vector of cell names to subset cell coordinates. If not specified will take all features available from specified reduction Embeddigns.}

\item{n.features}{single integer specifying how many top features should be extracted from the ranking}
}
\value{
A cell named list of gene rankings ordererd by distances from shortest (most specfic) to farthest (less specific)
}
\description{
Calculate cells and genes distances, rank them per cell and extract top n features.
The obtained top n features represents features thatare highly specific to that cell.
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
GroupGeneRanking <- GetGroupGeneRanking(seuratPbmc, group.by = "seurat_clusters", dims = 1:5)
}
