% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{GetGroupCoordinates}
\alias{GetGroupCoordinates}
\alias{GetGroupCoordinates.matrix}
\alias{GetGroupCoordinates.Seurat}
\alias{GetGroupCoordinates.SingleCellExperiment}
\title{Centroids Coordinates}
\usage{
GetGroupCoordinates(X, group.by, reduction, dims, ...)

\method{GetGroupCoordinates}{matrix}(X, group.by, reduction = NULL, dims, ...)

\method{GetGroupCoordinates}{Seurat}(X, group.by = NULL, reduction = "mca", dims = seq(50), ...)

\method{GetGroupCoordinates}{SingleCellExperiment}(X, group.by = NULL, reduction = "MCA", dims, ...)
}
\arguments{
\item{X}{Seurat or SingleCellExperiment object, alternatively a matrix.}

\item{group.by}{column name of meta.data (Seurat) or ColData (SingleCellExperiment). For Seurat object if NULL active.ident slot will be taken.}

\item{reduction}{Which dimensionality reduction to use, must be based on MCA.}

\item{dims}{A vector of integers indicating which dimensions to use with reduction embeddings and loadings for distance calculation.}

\item{...}{Other arguments passed to methods}
}
\value{
A data.table with coordinates of the group centroids for the specidied dims.
}
\description{
Centroids calculation for a given group of cells defined for instance by cell type/ condition.
}
