% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcaAndReduction.R
\name{RunMCDMAP}
\alias{RunMCDMAP}
\alias{RunMCDMAP.Seurat}
\alias{RunMCDMAP.SingleCellExperiment}
\title{Diffusion Map on MCA coordinates}
\usage{
RunMCDMAP(X, reduction, features, dims, reduction.name, ...)

\method{RunMCDMAP}{Seurat}(
  X,
  reduction = "mca",
  features = NULL,
  dims = seq(50),
  reduction.name = "mcdmap",
  assay = DefaultAssay(X),
  ...
)

\method{RunMCDMAP}{SingleCellExperiment}(
  X,
  reduction = "MCA",
  features = NULL,
  dims = seq(50),
  reduction.name = "MCDMAP",
  ...
)
}
\arguments{
\item{X}{Seurat or SingleCellExperiment object}

\item{reduction}{Which dimensionality reduction to use, must be based on MCA.}

\item{features}{Character vector of feature names to subset feature coordinates. If not specified will take all features available from specified reduction Loadings.}

\item{dims}{A vector of integers indicating which dimensions to use with reduction embeddings and loadings for distance calculation.}

\item{reduction.name}{name of the created dimensionlaity reduction, default set to "mca" for Seurat and "MCA" for SCE.}

\item{...}{other arguments passed to methods or DiffusionMap}

\item{assay}{Seurat Asssay slot name.}
}
\value{
Seurat or SingleCellExperiment object with MCDMAP stored in the reduction slot
}
\description{
(!EXPERIMENTAL) Run DiffusionMap on MCA cell and feature coordinates. 
This will allow to draw the trajectory of both cells and the genes at the same time.
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
seuratPbmc <- RunMCDMAP(seuratPbmc, dims = seq(5), k = 5)
}
