% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcaAndReduction.R
\name{RunMCUMAP}
\alias{RunMCUMAP}
\alias{RunMCUMAP.Seurat}
\alias{RunMCUMAP.SingleCellExperiment}
\title{UMAP on MCA coordinates}
\usage{
RunMCUMAP(X, reduction, dims, features, reduction.name, ...)

\method{RunMCUMAP}{Seurat}(
  X,
  reduction = "mca",
  dims = seq(50),
  features = NULL,
  reduction.name = "mcumap",
  assay = DefaultAssay(X),
  ...
)

\method{RunMCUMAP}{SingleCellExperiment}(
  X,
  reduction = "MCA",
  dims = seq(50),
  features = NULL,
  reduction.name = "MCUMAP",
  ...
)
}
\arguments{
\item{X}{Seurat or SingleCellExperiment object}

\item{reduction}{Which dimensionality reduction to use, must be based on MCA.}

\item{dims}{A vector of integers indicating which dimensions to use with reduction embeddings and loadings for distance calculation.}

\item{features}{Character vector of feature names to subset feature coordinates. If not specified will take all features available from specified reduction Loadings.}

\item{reduction.name}{name of the created dimensionlaity reduction, default set to "mca" for Seurat and "MCA" for SCE.}

\item{...}{other arguments passed to methods or Rtsne::Rtsne}

\item{assay}{Seurat assay slot to assign MCUMAP. When not specified set to DefaultAssay(X)}
}
\value{
Seurat or SingleCellExperiment object with MCUMAP stored in the reduction slot
}
\description{
(!EXPERIMENTAL) Run UMAP on MCA fetures and cells coordinates.
This will allow to embbed in 2D both cells and the genes at the same time.
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
seuratPbmc <- RunMCUMAP(seuratPbmc, dims = seq(5))
}
