% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_summaryPlots.R
\name{FSRDistplot}
\alias{FSRDistplot}
\title{FSRDistplot}
\usage{
FSRDistplot(..., names.input = NULL, quantiles = c(0, 0.25, 0.5, 0.75, 1),
  depth.values = seq_len(30), both.strand = FALSE)
}
\arguments{
\item{...}{a \code{list} of \code{ExoData} objects, or several 
\code{ExoData} objects by themselves.}

\item{names.input}{a character vector with the names to use in the
plot. If it is empty \code{FSRDistplot} is going to create the names
as the names of the list when they are available or is going to 
name them as Sample: 1 ,... , Sample: k.}

\item{quantiles}{a numeric vector with the quantiles used to estimate the
FSR distribution at a given depth. The default value is 
\code{c(0,.25,.5,.75,1))}}

\item{depth.values}{a numeric vector indicating the regions with depth 
less or equal to, that are going to be filtered out. The defaulta values 
are \code{seq_len(50)}.}

\item{both.strand}{a logical value indicating if the \code{DataFrame} 
contains only regions with reads aligned to both strand or all. The default
value is \code{FALSE}.}
}
\value{
A \code{ggplot2} object with the FSR distribution plot.
}
\description{
\code{FSRDistplot} returns a \code{ggplot} object with the Forward 
Strand Ratio distribution plot to analyze strand imbalance in 
ChIP-exo data.
}
\examples{
data(exoExample)
FSRDistplot(exoExample)
}
